/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class NonBasicLandsInOpponentsGraveyards
implements DynamicValue {
    private static final FilterCard filter = new FilterCard("nonbasic land card");

    NonBasicLandsInOpponentsGraveyards() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int amount = 0;
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller != null) {
            for (UUID playerUUID : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (!controller.hasOpponent(playerUUID, game) || (player = game.getPlayer(playerUUID)) == null) continue;
                amount += player.getGraveyard().count(filter, sourceAbility.getControllerId(), sourceAbility, game);
            }
        }
        return amount;
    }

    public DynamicValue copy() {
        return this;
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return "nonbasic land cards in your opponents' graveyards";
    }

    static {
        filter.add((Predicate)CardType.LAND.getPredicate());
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

