/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class TargetControlledPermanentSharingOpponentPermanentCardType
extends TargetControlledPermanent {
    public TargetControlledPermanentSharingOpponentPermanentCardType() {
        this.filter = this.filter.copy();
        this.filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        this.withTargetName("nonland permanent you control");
    }

    private TargetControlledPermanentSharingOpponentPermanentCardType(TargetControlledPermanentSharingOpponentPermanentCardType target) {
        super((TargetControlledPermanent)target);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        EnumSet<CardType> cardTypes = this.getOpponentPermanentCardTypes(playerId, game);
        if (super.canTarget(playerId, id, source, game)) {
            Permanent permanent = game.getPermanent(id);
            for (CardType type : permanent.getCardType(game)) {
                if (!cardTypes.contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        EnumSet<CardType> cardTypes = this.getOpponentPermanentCardTypes(sourceControllerId, game);
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        MageObject targetSource = game.getObject(source);
        if (targetSource != null) {
            block0: for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
                for (CardType type : permanent.getCardType(game)) {
                    if (!cardTypes.contains(type)) continue;
                    possibleTargets.add(permanent.getId());
                    continue block0;
                }
            }
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public TargetControlledPermanentSharingOpponentPermanentCardType copy() {
        return new TargetControlledPermanentSharingOpponentPermanentCardType(this);
    }

    private EnumSet<CardType> getOpponentPermanentCardTypes(UUID sourceControllerId, Game game) {
        Player controller = game.getPlayer(sourceControllerId);
        EnumSet<CardType> cardTypes = EnumSet.noneOf(CardType.class);
        if (controller != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(sourceControllerId, game)) {
                if (!controller.hasOpponent(permanent.getControllerId(), game)) continue;
                cardTypes.addAll(permanent.getCardType(game));
            }
        }
        return cardTypes;
    }
}

