/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterSource;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetSource;

class TargetControlledSource
extends TargetSource {
    public TargetControlledSource() {
        super(1, 1, new FilterSource("source you control"));
    }

    private TargetControlledSource(TargetControlledSource target) {
        super((TargetSource)target);
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (StackObject stackObject : game.getStack()) {
            if (!game.getState().getPlayersInRange(sourceControllerId, game).contains((Object)stackObject.getControllerId()) || !Objects.equals(stackObject.getControllerId(), sourceControllerId)) continue;
            possibleTargets.add(stackObject.getId());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(sourceControllerId, game)) {
            if (!Objects.equals(permanent.getControllerId(), sourceControllerId)) continue;
            possibleTargets.add(permanent.getId());
        }
        for (Player player : game.getPlayers().values()) {
            if (!Objects.equals(player, game.getPlayer(sourceControllerId))) continue;
            for (Card card : player.getGraveyard().getCards(game)) {
                possibleTargets.add(card.getId());
            }
            for (Card card : game.getExile().getCardsInRange(game, sourceControllerId)) {
                if (!Objects.equals(card.getOwnerId(), sourceControllerId)) continue;
                possibleTargets.add(card.getId());
            }
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public TargetControlledSource copy() {
        return new TargetControlledSource(this);
    }
}

