/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EarthbindEffect
extends OneShotEffect {
    EarthbindEffect() {
        super(Outcome.Damage);
        this.staticText = "if enchanted creature has flying, {this} deals 2 damage to that creature and {this} gains \"Enchanted creature loses flying.\"";
    }

    private EarthbindEffect(EarthbindEffect effect) {
        super((OneShotEffect)effect);
    }

    public EarthbindEffect copy() {
        return new EarthbindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchanted;
        Permanent attachment = game.getPermanent(source.getSourceId());
        if (attachment != null && attachment.getAttachedTo() != null && (enchanted = game.getPermanent(attachment.getAttachedTo())) != null) {
            if (enchanted.getAbilities().contains((Ability)FlyingAbility.getInstance())) {
                enchanted.damage(2, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

