/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EatenBySpidersEffect
extends OneShotEffect {
    EatenBySpidersEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature with flying and all Equipment attached to that creature";
    }

    private EatenBySpidersEffect(EatenBySpidersEffect effect) {
        super((OneShotEffect)effect);
    }

    public EatenBySpidersEffect copy() {
        return new EatenBySpidersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            LinkedList attachments = new LinkedList();
            attachments.addAll(permanent.getAttachments());
            for (UUID attachmentId : attachments) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (!attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
                attachment.destroy(source, game, false);
            }
            permanent.destroy(source, game, false);
            return true;
        }
        return false;
    }
}

