/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;

class EbonyFlyEffect
extends OneShotEffect {
    EbonyFlyEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d6. Until end of turn, you may have {this} become an X/X Insect artifact creature with flying, where X is the result";
    }

    private EbonyFlyEffect(EbonyFlyEffect effect) {
        super((OneShotEffect)effect);
    }

    public EbonyFlyEffect copy() {
        return new EbonyFlyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !player.chooseUse(this.outcome, "Have " + permanent.getName() + " become a " + result + '/' + result + " creature until end of turn?", source, game)) {
            return true;
        }
        game.addEffect((ContinuousEffect)new BecomesCreatureSourceEffect((Token)new CreatureToken(result, result).withType(CardType.ARTIFACT).withAbility((Ability)FlyingAbility.getInstance()), CardType.ARTIFACT, Duration.EndOfTurn), source);
        return true;
    }
}

