/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EbonyOwlNetsukeTriggeredAbility
extends TriggeredAbilityImpl {
    EbonyOwlNetsukeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(4), false);
    }

    private EbonyOwlNetsukeTriggeredAbility(EbonyOwlNetsukeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EbonyOwlNetsukeTriggeredAbility copy() {
        return new EbonyOwlNetsukeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player player;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (player = game.getPlayer(event.getPlayerId())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
            }
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Player player = game.getPlayer(game.getActivePlayerId());
        return player != null && player.getHand().size() >= 7;
    }

    public String getRule() {
        return "At the beginning of each opponent's upkeep, if that player has seven or more cards in hand, {this} deals 4 damage to that player.";
    }
}

