/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EchoCircletEffect
extends ContinuousEffectImpl {
    EchoCircletEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Equipped creature can block an additional creature each combat";
    }

    private EchoCircletEffect(EchoCircletEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EchoCircletEffect copy() {
        return new EchoCircletEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent equipped;
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm != null && perm.getAttachedTo() != null && (equipped = game.getPermanent(perm.getAttachedTo())) != null) {
            switch (layer) {
                case RulesEffects: {
                    if (equipped.getMaxBlocks() <= 0) break;
                    equipped.setMaxBlocks(equipped.getMaxBlocks() + 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

