/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EchoingAssaultEffect
extends OneShotEffect {
    EchoingAssaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target nontoken creature that's attacking that player. Create a token that's a copy of that creature, except it's 1/1. The token enters tapped and attacking that player. Sacrifice it at the beginning of the next end step.";
    }

    private EchoingAssaultEffect(EchoingAssaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingAssaultEffect copy() {
        return new EchoingAssaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object attackedPlayer = this.getValue("playerAttacked");
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !(attackedPlayer instanceof UUID)) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true, (UUID)attackedPlayer, 1, 1, false);
        effect.setSavedPermanent(permanent);
        effect.apply(game, source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

