/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.TapSourceEffect;
import mage.cards.Card;
import mage.cards.e.EchoingDeepsApplier;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.functions.CopyApplier;

class EchoingDeepsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("land card in a graveyard");

    EchoingDeepsEffect() {
        super(Outcome.Copy);
        this.staticText = "tapped as a copy of any land card in a graveyard, except it's a Cave in addition to its other types";
    }

    private EchoingDeepsEffect(EchoingDeepsEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingDeepsEffect copy() {
        return new EchoingDeepsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentEntering(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = game.getObject(source);
        }
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, filter, false);
        controller.choose(Outcome.Copy, (Target)target, source, game);
        Card copyTo = game.getCard(target.getFirstTarget());
        if (copyTo == null) {
            return false;
        }
        new TapSourceEffect(true).apply(game, source);
        PermanentCard newBluePrint = new PermanentCard(copyTo, source.getControllerId(), game);
        newBluePrint.assignNewId();
        EchoingDeepsApplier applier = new EchoingDeepsApplier();
        applier.apply(game, (MageObject)newBluePrint, source, source.getSourceId());
        CopyEffect copyEffect = new CopyEffect(Duration.WhileOnBattlefield, (MageObject)newBluePrint, source.getSourceId());
        copyEffect.setApplier((CopyApplier)applier);
        copyEffect.init(source, game);
        game.addEffect((ContinuousEffect)copyEffect, source);
        return true;
    }

    static {
        filter.add((Predicate)CardType.LAND.getPredicate());
    }
}

