/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class EchoingReturnEffect
extends OneShotEffect {
    EchoingReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature card and all other cards with the same name as that card from your graveyard to your hand";
    }

    private EchoingReturnEffect(EchoingReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingReturnEffect copy() {
        return new EchoingReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(card);
        player.getGraveyard().getCards(game).stream().filter(c -> CardUtil.haveSameNames((String)c.getName(), (String)card.getName())).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

