/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCard;

class EivorWolfKissedEffect
extends OneShotEffect {
    EivorWolfKissedEffect() {
        super(Outcome.Benefit);
        this.staticText = "you mill that many cards. You may put a Saga card and/or a land card from among them onto the battlefield";
    }

    private EivorWolfKissedEffect(EivorWolfKissedEffect effect) {
        super((OneShotEffect)effect);
    }

    public EivorWolfKissedEffect copy() {
        return new EivorWolfKissedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int damage = (Integer)this.getValue("damage");
        if (player == null || damage < 1) {
            return false;
        }
        Cards cards = player.millCards(damage, source, game);
        TargetCardAndOrCard target = new TargetCardAndOrCard((Predicate)SubType.SAGA.getPredicate(), (Predicate)CardType.LAND.getPredicate(), "a Saga card and/or a land card");
        player.choose(this.outcome, cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }
}

