/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class EladamriKorvecdalEffect
extends OneShotEffect {
    EladamriKorvecdalEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Reveal a card from your hand or the top card of your library. If you reveal a creature card this way, put it onto the battlefield.";
    }

    private EladamriKorvecdalEffect(EladamriKorvecdalEffect effect) {
        super((OneShotEffect)effect);
    }

    public EladamriKorvecdalEffect copy() {
        return new EladamriKorvecdalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean canRevealFromHand;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean canRevealFromLibrary = player.getLibrary().hasCards();
        boolean bl = canRevealFromHand = !player.getHand().isEmpty();
        if (canRevealFromHand && canRevealFromLibrary) {
            if (player.chooseUse(Outcome.PutCreatureInPlay, "Where do you want to reveal a card from?", "", "from hand", "from top of library", source, game)) {
                this.revealFromHand(player, game, source);
            } else {
                this.revealFromTop(player, game, source);
            }
            return true;
        }
        if (canRevealFromHand) {
            return this.revealFromHand(player, game, source);
        }
        if (canRevealFromLibrary) {
            return this.revealFromTop(player, game, source);
        }
        return false;
    }

    private boolean revealFromTop(Player player, Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        Card card = player.getLibrary().getFromTop(game);
        MageObject mageObject = source.getSourceObject(game);
        if (card == null || mageObject == null) {
            return false;
        }
        cards.add(card);
        player.revealCards(mageObject.getName() + " (from top of library)", (Cards)cards, game, false);
        game.informPlayers(player.getLogName() + " reveals " + card.getLogName() + " from top of library" + CardUtil.getSourceLogName((Game)game, (Ability)source));
        if (card.isCreature(game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    private boolean revealFromHand(Player player, Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        Card card = null;
        boolean madeAChoice = false;
        if (player.getHand().size() > 0) {
            TargetCardInHand target = new TargetCardInHand(StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            if (player.chooseTarget(this.outcome, (Target)target, source, game)) {
                card = game.getCard(target.getFirstTarget());
                madeAChoice = true;
            }
        }
        MageObject mageObject = source.getSourceObject(game);
        if (card == null || mageObject == null) {
            return madeAChoice;
        }
        cards.add(card);
        player.revealCards(mageObject.getName() + " (from hand)", (Cards)cards, game, false);
        game.informPlayers(player.getLogName() + " reveals " + card.getLogName() + " from hand" + CardUtil.getSourceLogName((Game)game, (Ability)source));
        if (card.isCreature(game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

