/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ElanorGardnerWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    ElanorGardnerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SACRIFICED_PERMANENT) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent != null && permanent.hasSubtype(SubType.FOOD, game)) {
            this.set.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((ElanorGardnerWatcher)game.getState().getWatcher(ElanorGardnerWatcher.class)).set.contains(source.getControllerId());
    }
}

