/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ElderSpawnEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("an Island");

    public ElderSpawnEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "unless you sacrifice an Island, sacrifice {this} and it deals 6 damage to you";
    }

    private ElderSpawnEffect(ElderSpawnEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElderSpawnEffect copy() {
        return new ElderSpawnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)filter);
            if (!(controller.chooseUse(Outcome.AIDontUseIt, "Sacrifice an Island?", source, game) && cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), true))) {
                sourcePermanent.sacrifice(source, game);
                controller.damage(6, sourcePermanent.getId(), source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

