/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EldraziMimicEffect
extends OneShotEffect {
    EldraziMimicEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "you may change {this}'s base power and toughness to that creature's power and toughness until end of turn";
    }

    private EldraziMimicEffect(EldraziMimicEffect effect) {
        super((OneShotEffect)effect);
    }

    public EldraziMimicEffect copy() {
        return new EldraziMimicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || permanent == null) {
            return false;
        }
        SetBasePowerToughnessTargetEffect effect = new SetBasePowerToughnessTargetEffect(permanent.getPower().getValue(), permanent.getToughness().getValue(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

