/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class EldritchPactEffect
extends OneShotEffect {
    EldritchPactEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player draws X cards and loses X life, where X is the number of cards in their graveyard";
    }

    private EldritchPactEffect(EldritchPactEffect effect) {
        super((OneShotEffect)effect);
    }

    public EldritchPactEffect copy() {
        return new EldritchPactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = player.getGraveyard().size();
        if (count < 1) {
            return false;
        }
        player.drawCards(count, source, game);
        player.loseLife(count, game, source, false);
        return true;
    }
}

