/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPlayer;
import mage.util.ManaUtil;

class ElectroAssaultingBatteryEffect
extends OneShotEffect {
    ElectroAssaultingBatteryEffect() {
        super(Outcome.Damage);
        this.staticText = "you may pay x. When you do, he deals X damage to target player";
    }

    private ElectroAssaultingBatteryEffect(ElectroAssaultingBatteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElectroAssaultingBatteryEffect copy() {
        return new ElectroAssaultingBatteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.chooseUse(this.outcome, "Pay x mana to deal x damage to target player?", source, game)) {
            TargetPlayer target = new TargetPlayer();
            target.chooseTarget(this.outcome, controller.getId(), source, game);
            int amount = ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Electro, Assaulting Battery", (Player)controller, (Ability)source, (Game)game);
            Player targetOpponent = game.getPlayer(target.getFirstTarget());
            if (targetOpponent != null) {
                targetOpponent.damage(amount, source, game);
            }
        }
        return true;
    }
}

