/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.token.RedElementalWithTrampleAndHaste;
import mage.game.permanent.token.Token;

class ElementalAppealEffect
extends OneShotEffect {
    ElementalAppealEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a 7/1 red Elemental creature token with trample and haste. Exile it at the beginning of the next end step. If this spell was kicked, that creature gets +7/+0 until end of turn";
    }

    private ElementalAppealEffect(ElementalAppealEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElementalAppealEffect copy() {
        return new ElementalAppealEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenEffect effect = new CreateTokenEffect((Token)new RedElementalWithTrampleAndHaste());
        if (effect.apply(game, source)) {
            effect.exileTokensCreatedAtNextEndStep(game, source);
            if (KickedCondition.ONCE.apply(game, source)) {
                ArrayList<CardIdPredicate> predList = new ArrayList<CardIdPredicate>();
                for (UUID tokenId : effect.getLastAddedTokenIds()) {
                    predList.add(new CardIdPredicate(tokenId));
                }
                if (!predList.isEmpty()) {
                    FilterCreaturePermanent filter = new FilterCreaturePermanent();
                    filter.add(Predicates.or(predList));
                    game.addEffect((ContinuousEffect)new BoostAllEffect(7, 0, Duration.EndOfTurn, filter, false), source);
                }
            }
            return true;
        }
        return false;
    }
}

