/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Elemental11HasteToken;
import mage.game.permanent.token.Token;

class ElementalMasteryEffect
extends OneShotEffect {
    ElementalMasteryEffect() {
        super(Outcome.Benefit);
        this.staticText = "create X 1/1 red Elemental creature tokens with haste, where X is this creature's power. Exile them at the beginning of the next end step";
    }

    private ElementalMasteryEffect(ElementalMasteryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElementalMasteryEffect copy() {
        return new ElementalMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power;
        Permanent creatureAttached = game.getPermanent(source.getSourceId());
        if (creatureAttached != null && (power = creatureAttached.getPower().getValue()) > 0) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new Elemental11HasteToken(), power);
            effect.apply(game, source);
            effect.exileTokensCreatedAtNextEndStep(game, source);
            return true;
        }
        return false;
    }
}

