/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.Arrays;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ElementalResonanceEffect
extends OneShotEffect {
    ElementalResonanceEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "add mana equal to enchanted permanent's mana cost.";
    }

    private ElementalResonanceEffect(ElementalResonanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElementalResonanceEffect copy() {
        return new ElementalResonanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent thisPerm = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (thisPerm == null) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(thisPerm.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<String> manaOptions = new ArrayList<String>();
        for (Mana mana : permanent.getManaCost().getOptions()) {
            String manaString = mana.toString();
            if (manaOptions.contains(manaString)) continue;
            manaOptions.add(manaString);
        }
        String manaToAdd = "";
        if (manaOptions.size() > 1) {
            ChoiceImpl choice = new ChoiceImpl(false);
            choice.setMessage("Choose a mana combination");
            choice.getChoices().addAll(manaOptions);
            if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                return false;
            }
            manaToAdd = choice.getChoice();
        } else if (manaOptions.size() == 1) {
            manaToAdd = (String)manaOptions.get(0);
        }
        if (!manaToAdd.equals("")) {
            controller.getManaPool().addMana(ElementalResonanceEffect.getManaFromString(manaToAdd), game, source);
        }
        return true;
    }

    private static Mana getManaFromString(String manaString) {
        Mana out = new Mana(0, 0, 0, 0, 0, 0, 0, 0);
        Integer generic = 0;
        for (String str : Arrays.asList(manaString.replaceAll("[^-?0-9]+", " ").trim().split(" "))) {
            if (str.equals("")) continue;
            generic = generic + Integer.parseInt(str);
        }
        out.setColorless(generic.intValue());
        block9: for (Object c : (Object)manaString.toCharArray()) {
            switch (c) {
                case 87: {
                    out.increaseWhite();
                    continue block9;
                }
                case 85: {
                    out.increaseBlue();
                    continue block9;
                }
                case 66: {
                    out.increaseBlack();
                    continue block9;
                }
                case 82: {
                    out.increaseRed();
                    continue block9;
                }
                case 71: {
                    out.increaseGreen();
                    continue block9;
                }
                case 67: {
                    out.increaseColorless();
                }
            }
        }
        return out;
    }
}

