/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.e.ElementalistsPaletteManaBuilder;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ElementalistsPaletteManaEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder = new ElementalistsPaletteManaBuilder();

    ElementalistsPaletteManaEffect() {
        this.staticText = "add {C} for each charge counter on {this}. Spend this mana only on costs that contain {X}";
    }

    private ElementalistsPaletteManaEffect(ElementalistsPaletteManaEffect effect) {
        super((ManaEffect)effect);
    }

    public ElementalistsPaletteManaEffect copy() {
        return new ElementalistsPaletteManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            netMana.add((Mana)this.manaBuilder.setMana(Mana.ColorlessMana((int)permanent.getCounters(game).getCount(CounterType.CHARGE)), source, game).build(new Object[0]));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return mana;
        }
        return (Mana)this.manaBuilder.setMana(Mana.ColorlessMana((int)permanent.getCounters(game).getCount(CounterType.CHARGE)), source, game).build(new Object[0]);
    }
}

