/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class EliteSpellbinderCostEffect
extends CostModificationEffectImpl {
    private final MageObjectReference mor;

    EliteSpellbinderCostEffect(Card card, Game game) {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.mor = new MageObjectReference((MageObject)card, game, 1);
    }

    private EliteSpellbinderCostEffect(EliteSpellbinderCostEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (game.inCheckPlayableState()) {
            UUID cardtoCheckId = CardUtil.getMainCardId((Game)game, (UUID)abilityToModify.getSourceId());
            return this.mor.getSourceId().equals(cardtoCheckId) && this.mor.getZoneChangeCounter() == game.getState().getZoneChangeCounter(cardtoCheckId) + 1;
        }
        return this.mor.refersTo(CardUtil.getMainCardId((Game)game, (UUID)abilityToModify.getSourceId()), game);
    }

    public EliteSpellbinderCostEffect copy() {
        return new EliteSpellbinderCostEffect(this);
    }
}

