/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.e.ElkinLairPutIntoGraveyardEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class ElkinLairUpkeepEffect
extends OneShotEffect {
    ElkinLairUpkeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player exiles a card at random from their hand. The player may play that card this turn. At the beginning of the next end step, if the player hasn't played the card, they put it into their graveyard";
    }

    private ElkinLairUpkeepEffect(ElkinLairUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElkinLairUpkeepEffect copy() {
        return new ElkinLairUpkeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player == null || sourcePermanent == null) {
            return false;
        }
        Card[] cards = player.getHand().getCards(new FilterCard(), game).toArray(new Card[0]);
        if (cards.length == 0) {
            return false;
        }
        Card card = cards[RandomUtil.nextInt((int)cards.length)];
        if (card == null) {
            return false;
        }
        String exileName = sourcePermanent.getIdName() + " <this card may be played the turn it was exiled";
        player.moveCardsToExile(card, source, game, true, source.getSourceId(), exileName);
        if (game.getState().getZone(card.getId()) != Zone.EXILED) {
            return false;
        }
        PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.OWNER, Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        game.addEffect((ContinuousEffect)effect, source);
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayed = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ElkinLairPutIntoGraveyardEffect());
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayed, source);
        return true;
    }
}

