/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.e.ElsewhereFlaskContinuousEffect;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ElsewhereFlaskEffect
extends OneShotEffect {
    ElsewhereFlaskEffect() {
        super(Outcome.Neutral);
        this.staticText = "Choose a basic land type. Each land you control becomes that type until end of turn";
    }

    private ElsewhereFlaskEffect(ElsewhereFlaskEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElsewhereFlaskEffect copy() {
        return new ElsewhereFlaskEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ChoiceBasicLandType choice = new ChoiceBasicLandType();
        if (player != null && player.choose(Outcome.Neutral, (Choice)choice, game)) {
            game.getState().setValue(source.getSourceId().toString() + "_ElsewhereFlask", (Object)choice.getChoice());
            game.addEffect((ContinuousEffect)new ElsewhereFlaskContinuousEffect(), source);
            return true;
        }
        return false;
    }
}

