/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class ElspethConquersDeathCostEffect
extends CostModificationEffectImpl {
    ElspethConquersDeathCostEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Noncreature spells your opponents cast cost {2} more to cast until your next turn";
    }

    private ElspethConquersDeathCostEffect(ElspethConquersDeathCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        CardUtil.adjustCost((SpellAbility)spellAbility, (int)-2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card spellCard;
        if (abilityToModify instanceof SpellAbility && game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId()) && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null) {
            return !spellCard.isCreature(game);
        }
        return false;
    }

    public ElspethConquersDeathCostEffect copy() {
        return new ElspethConquersDeathCostEffect(this);
    }
}

