/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ElspethConquersDeathReturnEffect
extends OneShotEffect {
    ElspethConquersDeathReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature or planeswalker card from your graveyard to the battlefield. Put a +1/+1 counter or a loyalty counter on it";
    }

    private ElspethConquersDeathReturnEffect(ElspethConquersDeathReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElspethConquersDeathReturnEffect copy() {
        return new ElspethConquersDeathReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        Counter counter = player.chooseUse(this.outcome, "Choose a type of counter to add", null, "+1/+1", "Loyalty", source, game) ? CounterType.P1P1.createInstance() : CounterType.LOYALTY.createInstance();
        permanent.addCounters(counter, source.getControllerId(), source, game);
        return true;
    }
}

