/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.abilities.effects.common.replacement.CreateTwiceThatManyTokensEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterOpponentsCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class ElspethStormSlayer
extends CardImpl {
    private static final FilterPermanent filter = new FilterOpponentsCreaturePermanent("creature an opponent controls with mana value 3 or greater");

    public ElspethStormSlayer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{3}{W}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.ELSPETH);
        this.setStartingLoyalty(5);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CreateTwiceThatManyTokensEffect()));
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new SoldierToken()), 1));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new AddCountersAllEffect(CounterType.P1P1.createInstance(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE), 0);
        ability.addEffect((Effect)new GainAbilityControlledEffect((Ability)FlyingAbility.getInstance(), Duration.UntilYourNextTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).setText("those creatures gain flying until your next turn"));
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new DestroyTargetEffect(), -3);
        ability.addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)ability);
    }

    private ElspethStormSlayer(ElspethStormSlayer card) {
        super((CardImpl)card);
    }

    public ElspethStormSlayer copy() {
        return new ElspethStormSlayer(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 2));
    }
}

