/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;

class ElspethTirelThirdEffect
extends OneShotEffect {
    ElspethTirelThirdEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all other permanents except for lands and tokens";
    }

    private ElspethTirelThirdEffect(ElspethTirelThirdEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (perm.getId().equals(source.getSourceId()) || perm instanceof PermanentToken || perm.isLand(game)) continue;
            perm.destroy(source, game, false);
        }
        return true;
    }

    public ElspethTirelThirdEffect copy() {
        return new ElspethTirelThirdEffect(this);
    }
}

