/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class ElspethsTalentTriggeredAbility
extends TriggeredAbilityImpl {
    ElspethsTalentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostControlledEffect(2, 2, Duration.EndOfTurn));
        this.addEffect((Effect)new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE));
    }

    private ElspethsTalentTriggeredAbility(ElspethsTalentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ElspethsTalentTriggeredAbility copy() {
        return new ElspethsTalentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent == null) return false;
        if (!event.getSourceId().equals(permanent.getAttachedTo())) return false;
        if (!this.isControlledBy(event.getPlayerId())) return false;
        if (Optional.ofNullable(game.getStack().getStackObject(event.getSourceId())).map(StackObject::getStackAbility).map(LoyaltyAbility.class::isInstance).orElse(false) == false) return false;
        return true;
    }

    public String getRule() {
        return "Whenever you activate a loyalty ability of enchanted planeswalker, creatures you control get +2/+2 and gain vigilance until end of turn.";
    }
}

