/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class EmbermawHellionEffect
extends ReplacementEffectImpl {
    EmbermawHellionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If another red source you control would deal damage to a permanent or player, it deals that much damage plus 1 to that permanent or player instead.";
    }

    private EmbermawHellionEffect(EmbermawHellionEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            Object sourceObject = sourcePermanent == null ? game.getObject(event.getSourceId()) : sourcePermanent;
            return sourceObject != null && sourceObject.getColor(game).isRed() && !sourceObject.getId().equals(source.getSourceId());
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }

    public EmbermawHellionEffect copy() {
        return new EmbermawHellionEffect(this);
    }
}

