/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.cards.Card;
import mage.cards.e.EmergentSequenceWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FractalToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class EmergentSequenceEffect
extends OneShotEffect {
    EmergentSequenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a basic land card, put it onto the battlefield tapped, then shuffle. That land becomes a 0/0 green and blue Fractal creature that's still a land. Put a +1/+1 counter on it for each land you had enter the battlefield under your control this turn";
    }

    private EmergentSequenceEffect(EmergentSequenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmergentSequenceEffect copy() {
        return new EmergentSequenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND_A);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        player.shuffleLibrary(source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return true;
        }
        game.addEffect(new BecomesCreatureTargetEffect((Token)new FractalToken(), false, true, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.processAction();
        int amount = EmergentSequenceWatcher.getAmount(source.getControllerId(), game);
        permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
        return true;
    }
}

