/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;

class EmissaryGreenEffect
extends OneShotEffect {
    EmissaryGreenEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for profit or security. You create a number of Treasure tokens equal to twice the number of profit votes. Put a number of +1/+1 counters on each creature you control equal to the number of security votes.";
    }

    private EmissaryGreenEffect(EmissaryGreenEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmissaryGreenEffect copy() {
        return new EmissaryGreenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Profit (treasure)", "Security (+1/+1 counters)", Outcome.Detriment);
        vote.doVotes(source, game);
        int profitCounter = vote.getVoteCount((Object)true);
        int securityCounter = vote.getVoteCount((Object)false);
        if (profitCounter > 0) {
            new TreasureToken().putOntoBattlefield(2 * profitCounter, game, source);
        }
        if (securityCounter > 0) {
            AddCountersAllEffect countersAllEffect = new AddCountersAllEffect(CounterType.P1P1.createInstance(), (DynamicValue)StaticValue.get((int)securityCounter), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
            countersAllEffect.setText("put a number of +1/+1 counters on each creature you control equal to the number of security votes.");
            countersAllEffect.apply(game, source);
        }
        return profitCounter + securityCounter > 0;
    }
}

