/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.keyword.ProtectionAbility;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EmptyShrineKannushiProtectionAbility
extends ProtectionAbility {
    public EmptyShrineKannushiProtectionAbility() {
        super((Filter)new FilterCard());
    }

    private EmptyShrineKannushiProtectionAbility(EmptyShrineKannushiProtectionAbility ability) {
        super((ProtectionAbility)ability);
    }

    public EmptyShrineKannushiProtectionAbility copy() {
        return new EmptyShrineKannushiProtectionAbility(this);
    }

    public boolean canTarget(MageObject source, Game game) {
        ObjectColor color = new ObjectColor();
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(this.controllerId)) {
            ObjectColor permanentColor = permanent.getColor(game);
            if (permanentColor.isColorless()) continue;
            if (permanentColor.isBlack()) {
                color.setBlack(true);
            }
            if (permanentColor.isBlue()) {
                color.setBlue(true);
            }
            if (permanentColor.isGreen()) {
                color.setGreen(true);
            }
            if (permanentColor.isRed()) {
                color.setRed(true);
            }
            if (!permanentColor.isWhite()) continue;
            color.setWhite(true);
        }
        ArrayList<ColorPredicate> colorPredicates = new ArrayList<ColorPredicate>();
        if (color.isBlack()) {
            colorPredicates.add(new ColorPredicate(ObjectColor.BLACK));
        }
        if (color.isBlue()) {
            colorPredicates.add(new ColorPredicate(ObjectColor.BLUE));
        }
        if (color.isGreen()) {
            colorPredicates.add(new ColorPredicate(ObjectColor.GREEN));
        }
        if (color.isRed()) {
            colorPredicates.add(new ColorPredicate(ObjectColor.RED));
        }
        if (color.isWhite()) {
            colorPredicates.add(new ColorPredicate(ObjectColor.WHITE));
        }
        FilterObject protectionFilter = new FilterObject("the colors of permanents you control");
        protectionFilter.add(Predicates.or(colorPredicates));
        this.filter = protectionFilter;
        return super.canTarget(source, game);
    }

    public String getRule() {
        return "{this} has protection from the colors of permanents you control.";
    }
}

