/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class EmrakulThePromisedEndGainControlEffect
extends OneShotEffect {
    EmrakulThePromisedEndGainControlEffect() {
        super(Outcome.GainControl);
        this.staticText = "you gain control of target opponent during that player's next turn. After that turn, that player takes an extra turn";
    }

    private EmrakulThePromisedEndGainControlEffect(EmrakulThePromisedEndGainControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public EmrakulThePromisedEndGainControlEffect copy() {
        return new EmrakulThePromisedEndGainControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPlayer != null) {
            TurnMod extraTurnMod = new TurnMod(targetPlayer.getId()).withExtraTurn();
            TurnMod newControllerTurnMod = new TurnMod(targetPlayer.getId()).withNewController(controller.getId(), extraTurnMod);
            game.getState().getTurnMods().add(newControllerTurnMod);
            return true;
        }
        return false;
    }
}

