/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.e.EnchantmentAlterationEffect;
import mage.cards.e.SharesEnchantedCardTypePredicate;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttachmentAttachedToCardTypePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class EnchantmentAlteration
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("aura attached to a creature or land");
    private static final FilterPermanent filter2 = new FilterPermanent("another target permanent that shares that type of creature or land");

    public EnchantmentAlteration(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{U}");
        this.getSpellAbility().addEffect((Effect)new EnchantmentAlterationEffect());
        TargetPermanent targetAura = new TargetPermanent(filter);
        this.getSpellAbility().addTarget((Target)targetAura);
        TargetPermanent targetCreatureOrLandThatSharesTheEnchantedCardType = new TargetPermanent(filter2);
        this.getSpellAbility().addTarget((Target)targetCreatureOrLandThatSharesTheEnchantedCardType);
    }

    private EnchantmentAlteration(EnchantmentAlteration card) {
        super((CardImpl)card);
    }

    public EnchantmentAlteration copy() {
        return new EnchantmentAlteration(this);
    }

    static {
        filter.add((Predicate)SubType.AURA.getPredicate());
        filter.add(Predicates.or((Predicate)new AttachmentAttachedToCardTypePredicate(CardType.CREATURE), (Predicate)new AttachmentAttachedToCardTypePredicate(CardType.LAND)));
        filter2.add((ObjectSourcePlayerPredicate)new SharesEnchantedCardTypePredicate());
    }
}

