/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class EnchantmentAlterationEffect
extends OneShotEffect {
    EnchantmentAlterationEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Attach target Aura attached to a creature or land to another permanent of that type";
    }

    private EnchantmentAlterationEffect(EnchantmentAlterationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnchantmentAlterationEffect copy() {
        return new EnchantmentAlterationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent oldPermanent;
            Permanent aura = game.getPermanent(source.getFirstTarget());
            Permanent permanentToBeAttachedTo = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            if (aura != null && permanentToBeAttachedTo != null && (oldPermanent = game.getPermanent(aura.getAttachedTo())) != null && !oldPermanent.equals(permanentToBeAttachedTo)) {
                Target auraTarget = (Target)aura.getSpellAbility().getTargets().get(0);
                if (!auraTarget.canTarget(permanentToBeAttachedTo.getId(), source, game)) {
                    game.informPlayers(aura.getLogName() + " was not attched to " + permanentToBeAttachedTo.getLogName() + " because it's no legal target for the aura");
                } else if (oldPermanent.removeAttachment(aura.getId(), source, game)) {
                    game.informPlayers(aura.getLogName() + " was unattached from " + oldPermanent.getLogName() + " and attached to " + permanentToBeAttachedTo.getLogName());
                    permanentToBeAttachedTo.addAttachment(aura.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

