/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class EncroachingMycosynthEffect
extends ContinuousEffectImpl {
    EncroachingMycosynthEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "Nonland permanents you control are artifacts in addition to their other types. The same is true for permanent spells you control and nonland permanent cards you own that aren't on the battlefield";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependencyTypes.add(DependencyType.ArtifactAddingRemoving);
    }

    private EncroachingMycosynthEffect(EncroachingMycosynthEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EncroachingMycosynthEffect copy() {
        return new EncroachingMycosynthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            card = game.getCard(cardId);
            if (card == null || !card.isPermanent(game) || card.isLand(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (UUID cardId : controller.getHand()) {
            card = game.getCard(cardId);
            if (card == null || !card.isPermanent(game) || card.isLand(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (Card card2 : game.getState().getExile().getCardsOwned(game, source.getControllerId())) {
            if (!card2.isPermanent(game) || card2.isLand(game) || card2.isArtifact(game)) continue;
            card2.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (Card card2 : controller.getLibrary().getCards(game)) {
            if (!card2.isOwnedBy(controller.getId()) || !card2.isPermanent(game) || card2.isLand(game) || card2.isArtifact(game)) continue;
            card2.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (CommandObject commandObject : game.getState().getCommand()) {
            if (!(commandObject instanceof Commander) || (card = game.getCard(commandObject.getId())) == null || !card.isOwnedBy(controller.getId()) || !card.isPermanent(game) || card.isLand(game) || card.isArtifact(game)) continue;
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !stackObject.isControlledBy(source.getControllerId()) || !stackObject.isPermanent(game) || stackObject.isLand(game) || stackObject.isArtifact(game)) continue;
            card = ((Spell)stackObject).getCard();
            card.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        FilterNonlandPermanent filter = new FilterNonlandPermanent("nonland permanents you control");
        filter.add((Predicate)new ControllerIdPredicate(source.getControllerId()));
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            if (permanent == null) continue;
            permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        return true;
    }
}

