/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EndHostilitiesEffect
extends OneShotEffect {
    EndHostilitiesEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures and all permanents attached to creatures.";
    }

    private EndHostilitiesEffect(EndHostilitiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public EndHostilitiesEffect copy() {
        return new EndHostilitiesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<Permanent> toDestroy = new ArrayList<Permanent>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(controller.getId(), game)) {
                Permanent attachedTo;
                if (permanent.isCreature(game)) {
                    toDestroy.add(permanent);
                    continue;
                }
                if (permanent.getAttachedTo() == null || (attachedTo = game.getPermanent(permanent.getAttachedTo())) == null || !attachedTo.isCreature(game)) continue;
                toDestroy.add(permanent);
            }
            for (Permanent permanent : toDestroy) {
                permanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

