/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class EnergyStormPreventionEffect
extends PreventionEffectImpl {
    EnergyStormPreventionEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false);
        this.staticText = "prevent all damage that would be dealt by instant and sorcery spells";
    }

    private EnergyStormPreventionEffect(EnergyStormPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public EnergyStormPreventionEffect copy() {
        return new EnergyStormPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getSourceId());
        return spell != null && (spell.isInstant(game) || spell.isSorcery(game));
    }
}

