/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EnfysNestEffect
extends ExileTargetEffect {
    EnfysNestEffect() {
        this.staticText = "you may exile target creature an opponent controls. If you do, that player gains life equal to that creature's power";
    }

    private EnfysNestEffect(EnfysNestEffect effect) {
        super((ExileTargetEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            if (!super.apply(game, source)) {
                return false;
            }
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                player.gainLife(permanent.getPower().getValue(), game, source);
                return true;
            }
        }
        return false;
    }

    public EnfysNestEffect copy() {
        return new EnfysNestEffect(this);
    }
}

