/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class EngulfTheShoreEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("number of Islands you control");

    public EngulfTheShoreEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return to their owners' hands all creatures with toughness less than or equal to the number of Islands you control";
    }

    private EngulfTheShoreEffect(EngulfTheShoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public EngulfTheShoreEffect copy() {
        return new EngulfTheShoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int islands = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
            FilterCreaturePermanent creatureFilter = new FilterCreaturePermanent();
            creatureFilter.add((Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, islands + 1));
            HashSet<Permanent> cardsToHand = new HashSet<Permanent>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)creatureFilter, source.getControllerId(), source, game)) {
                cardsToHand.add(permanent);
            }
            controller.moveCards(cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

