/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class EntrailsFeasterEffect
extends OneShotEffect {
    public EntrailsFeasterEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may exile a creature card from a graveyard. If you do, put a +1/+1 counter on {this}. If you don't, tap {this}";
    }

    private EntrailsFeasterEffect(EntrailsFeasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public EntrailsFeasterEffect copy() {
        return new EntrailsFeasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && source.getSourceId() != null) {
            Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_A_GRAVEYARD);
            target.withNotTarget(true);
            if (target.canChoose(controller.getId(), source, game) && controller.chooseUse(this.outcome, "Exile a creature card from a graveyard?", source, game)) {
                if (controller.choose(Outcome.Exile, (Target)target, source, game)) {
                    Card cardChosen = game.getCard(target.getFirstTarget());
                    if (cardChosen != null) {
                        controller.moveCardsToExile(cardChosen, source, game, true, null, "");
                        if (sourceObject != null) {
                            sourceObject.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                            game.informPlayers(controller.getLogName() + " puts a +1/+1 counter on " + sourceObject.getLogName());
                        }
                    }
                } else if (sourceObject != null) {
                    sourceObject.tap(source, game);
                }
            } else if (sourceObject != null) {
                sourceObject.tap(source, game);
            }
            return true;
        }
        return false;
    }
}

