/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class EntrapmentManeuverSacrificeEffect
extends OneShotEffect {
    EntrapmentManeuverSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices an attacking creature. You create X 1/1 white Soldier creature tokens, where X is that creature's toughness";
    }

    private EntrapmentManeuverSacrificeEffect(EntrapmentManeuverSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public EntrapmentManeuverSacrificeEffect copy() {
        return new EntrapmentManeuverSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        if (game.getBattlefield().count(TargetSacrifice.makeFilter((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURE), player.getId(), source, game) > 0) {
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURE);
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                int amount = permanent.getToughness().getValue();
                permanent.sacrifice(source, game);
                new CreateTokenEffect((Token)new SoldierToken(), amount).apply(game, source);
            } else {
                return false;
            }
        }
        return true;
    }
}

