/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.predicate.permanent.EquippedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class EowynLadyOfRohanEffect
extends OneShotEffect {
    EowynLadyOfRohanEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature gains your choice of first strike or vigilance until end of turn. If that creature is equipped, it gains first strike and vigilance until end of turn instead";
    }

    private EowynLadyOfRohanEffect(EowynLadyOfRohanEffect effect) {
        super((OneShotEffect)effect);
    }

    public EowynLadyOfRohanEffect copy() {
        return new EowynLadyOfRohanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (EquippedPredicate.instance.apply(permanent, game)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            game.addEffect(new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FirstStrikeAbility ability = player.chooseUse(this.outcome, "Choose first strike or vigilance", null, "First strike", "Vigilance", source, game) ? FirstStrikeAbility.getInstance() : VigilanceAbility.getInstance();
        game.addEffect(new GainAbilityTargetEffect((Ability)ability, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

