/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class EowynShieldmaidenWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> humanEnterings = new HashMap<UUID, Set<MageObjectReference>>();

    EowynShieldmaidenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && !game.isSimulation()) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (permanent == null || !permanent.hasSubtype(SubType.HUMAN, game)) {
                return;
            }
            UUID playerId = event.getPlayerId();
            Set setForThatPlayer = this.humanEnterings.getOrDefault(playerId, new HashSet());
            MageObjectReference humanMOR = new MageObjectReference(permanent.getId(), game);
            setForThatPlayer.add(humanMOR);
            this.humanEnterings.put(playerId, setForThatPlayer);
        }
    }

    public void reset() {
        super.reset();
        this.humanEnterings.clear();
    }

    boolean hasPlayerHadAnotherHumanEnterThisTurn(Game game, Permanent sourcePermanent, UUID playerId) {
        MageObjectReference sourceMOR = sourcePermanent == null ? null : new MageObjectReference(sourcePermanent.getId(), game);
        Set setForThePlayer = this.humanEnterings.getOrDefault(playerId, new HashSet());
        return setForThePlayer.stream().anyMatch(humanMOR -> !humanMOR.equals((Object)sourceMOR));
    }
}

