/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;

class EqualTreatmentEffect
extends ReplacementEffectImpl {
    EqualTreatmentEffect() {
        super(Duration.EndOfTurn, Outcome.PreventDamage);
        this.staticText = "If any source would deal 1 or more damage to a permanent or player this turn, it deals 2 damage to that permanent or player instead";
    }

    private EqualTreatmentEffect(EqualTreatmentEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public EqualTreatmentEffect copy() {
        return new EqualTreatmentEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getAmount() > 0;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        damageEvent.setAmount(2);
        return false;
    }
}

