/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Locale;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutAllEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class EquipoiseEffect
extends OneShotEffect {
    EquipoiseEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each land target player controls in excess of the number you control, choose a land they control, then the chosen permanents phase out. Repeat this process for artifacts and creatures";
    }

    private EquipoiseEffect(EquipoiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public EquipoiseEffect copy() {
        return new EquipoiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPlayer != null) {
            if (!Objects.equals(targetPlayer, controller)) {
                this.phaseOutCardType(controller, targetPlayer, CardType.LAND, source, game);
                this.phaseOutCardType(controller, targetPlayer, CardType.ARTIFACT, source, game);
                this.phaseOutCardType(controller, targetPlayer, CardType.CREATURE, source, game);
            }
            return true;
        }
        return false;
    }

    private void phaseOutCardType(Player controller, Player targetPlayer, CardType cardType, Ability source, Game game) {
        FilterControlledPermanent filter = new FilterControlledPermanent();
        filter.add((Predicate)cardType.getPredicate());
        int numberController = game.getBattlefield().count((FilterPermanent)filter, controller.getId(), source, game);
        int numberTargetPlayer = game.getBattlefield().count((FilterPermanent)filter, targetPlayer.getId(), source, game);
        int excess = numberTargetPlayer - numberController;
        if (excess > 0) {
            FilterPermanent filterChoose = new FilterPermanent(cardType.toString().toLowerCase(Locale.ENGLISH) + (excess > 1 ? "s" : "") + " of target player");
            filterChoose.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            filterChoose.add((Predicate)cardType.getPredicate());
            TargetPermanent target = new TargetPermanent(excess, excess, filterChoose, true);
            controller.chooseTarget(this.outcome, (Target)target, source, game);
            new PhaseOutAllEffect(target.getTargets()).apply(game, source);
        }
    }
}

