/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.FlipSourceEffect;
import mage.cards.e.ErayosEssenceToken;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.watchers.common.CastSpellLastTurnWatcher;

class ErayoSoratamiAscendantTriggeredAbility
extends TriggeredAbilityImpl {
    public ErayoSoratamiAscendantTriggeredAbility() {
        super(Zone.BATTLEFIELD, ErayoSoratamiAscendantTriggeredAbility.getFlipEffect(), false);
        this.setTriggerPhrase("Whenever the fourth spell of a turn is cast, ");
    }

    private static Effect getFlipEffect() {
        FlipSourceEffect effect = new FlipSourceEffect((Token)new ErayosEssenceToken());
        effect.setText("flip {this}");
        return effect;
    }

    private ErayoSoratamiAscendantTriggeredAbility(ErayoSoratamiAscendantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        return watcher != null && watcher.getAmountOfSpellsAllPlayersCastOnCurrentTurn() == 4;
    }

    public ErayoSoratamiAscendantTriggeredAbility copy() {
        return new ErayoSoratamiAscendantTriggeredAbility(this);
    }
}

