/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToHandEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class ErebossTitanTriggeredAbility
extends TriggeredAbilityImpl {
    public ErebossTitanTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new DoIfCostPaid((Effect)new ReturnSourceFromGraveyardToHandEffect(), (Cost)new DiscardCardCost()));
        this.setTriggerPhrase("Whenever a creature card leaves an opponent's graveyard, ");
    }

    private ErebossTitanTriggeredAbility(ErebossTitanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ErebossTitanTriggeredAbility copy() {
        return new ErebossTitanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.GRAVEYARD) {
            Card card = game.getCard(zEvent.getTargetId());
            Player controller = game.getPlayer(this.getControllerId());
            return card != null && card.isCreature(game) && controller != null && controller.hasOpponent(card.getOwnerId(), game);
        }
        return false;
    }
}

